"Checkpoint" by George Oliver

[

Copyright (c) 2009 George Oliver

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]





Chapter 0 - Game

Include Basic Screen Effects by Emily Short.
Include Extended Banner by Stephen Granade.


To say list of thanks: 
	say
		"thanks to Graham Nelson, Emily Short, David Kinder, Andrew Hunter, and Stephen Granade."

The story copyright string is "22 February, 2009"

To say custom banner: 
	say line break;
	say "[bold type][story title][roman type]";
	say paragraph break;
	say "by [story author]";
	say paragraph break;
	say "Created with Inform 7";
	say line break;
	say "[story copyright string] / Release [release number] / [story serial number] / [I7 version number]";
	say line break;
	say "[list of extension credits]";
	say line break;
	say "[list of thanks]";
	say line break.

	
Rule for printing the player's obituary:
	say paragraph break;
	say "[custom banner]";
	wait for any key;
	stop game abruptly;
	rule succeeds. 

Check quitting the game: say "[custom banner]".

To decide whether game begins:
    if turn count is 1, 
	yes;
	otherwise no.

Rule for printing the banner text when game begins: do nothing.

When play begins: clear the screen.




Chapter 1 - Rooms

Section 0

Use full-length room descriptions. 

To say the exit description: say "You can go forward or back. "


Section 1 - The Post

To say the post description: say "They got in line at five in the morning. "

The Post is a room with printed name "The Post". The description is "[the post description][paragraph break][the exit description]".


Section 2 - The Line

To say the line exit description: say "You can step forward. "

To say the line description: say "The post is only seven meters wide, but it might as well be seven kilometers. "

The Line is a room with printed name "The Line". The description is "[the line description][paragraph break][the line exit description] ".


Section 3 - The Tower

To say the tower exit description: say "You can go down. "

To say the tower description: say "They are like a line of ants on the ground. "

The Tower is a room with printed name "The Tower". The description is "[the tower description][paragraph break][the tower exit description]".




Chapter 2 - Directions

Forward is a direction. The opposite of forward is backward. Understand "f / ahead" as forward. 

Backward is a direction. The opposite of backward is forward. Understand "b / back" as backward.

Index map with forward mapped as north. 
Index map with backward mapped as south. 

The Post is forward of The Line. 
The Line is forward of The Post.
The Tower is backward of The Post. 
The Post is down of The Tower.




Chapter 3 - Actors

Section 0

A person has an indexed text that varies called name.
Understand the name property as describing a person.


Section 1 - Control

Control is a privately-named thing. 

The name of Control is "Eldad".

Control is a person with printed name "[name of Control]".


Section 2 - Crowd

Crowd is a privately-named thing. 

The name of Crowd is "Mahmoud".

Crowd is a person with printed name "[name of Crowd]".




Chapter 4 - Props

A weapon is a kind of thing. 

The rifle is a weapon. 




Chapter 5 - Places

Control is in The Line.
Crowd is in The Post.
Crowd carries the rifle. 


